# FindOneOf()

Finds the first occurrence of any one of a set of characters in a string, from a specified start position.

The search is case-sensitive.

```
FindOneOf( set=string, string=string, start=number );
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| set | string | Yes | String that contains one or more characters to search for. |  |
| string | string | Yes | String in which to search. |  |
| start | number | No | Start position of search. | 1 |

# Examples

```cfml
    dump(FindOneOf("a", "a a a a b b b b" ));
    dump(FindOneOf("b", "a a a a b b b b" ));
    dump(FindOneOf("c", "a a a a b b b b" ));
```







# Categories

[Strings](../../categories/string.md)

# See Also

[string.findOneOf()](../objects/string/findoneof.md)