# FindLastNoCase()

Finds the last occurrence of a substring in a string, from a
        specified start position. If substring is not in string,
        returns zero. The search is case-insensitive.

**Introduced:** 5.3.5.22

```
FindLastNoCase( substring=string, string=string, start=number );
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| substring | string | Yes | String for which to search. |  |
| string | string | Yes | String in which to search. |  |
| start | number | No | End position of search from the left. | 1 |

# Examples

```cfml
sentences="Swansea Jack was a black retriever with a longish coat. He lived in the North Dock / River Tawe area of Swansea, what gave him the name of Swansea Jack. Swansea Jack's first rescue, in June 1931, when he saved a 12-year-old boy, went unreported.";

dump( right( sentences, len( sentences )- sentences.findlastnocase( "SwAnSeA JACK" ) + 1 ) );
```







# Categories

[Strings](../../categories/string.md)

# See Also

[string.findLastNoCase()](../objects/string/findlastnocase.md)