# FileWrite()

If you specify a file path, writes the entire content to the specified file. If you specify a file object, writes text or binary data to the file object.

```
FileWrite( file=any, data=any, charset=string );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| file | any | Yes | file path or object *Alias: filePath, source* |  |
| data | any | Yes | data to write to the file |  |
| charset | string | No | The character encoding in which the file contents is encoded. |  |

# Examples

```cfml
filewrite("filepath","fileContent to be write");
```




## Related System Properties / Environment Variables

- [LUCEE_RESOURCE_CHARSET](../environment-variables-system-properties.md#lucee_resource_charset) - Default character set for reading from/writing to various resources (files)
  ***Type:** string, **Default:** system charset*



# Categories

[Binary data](../../categories/binary.md), [File handling](../../categories/files.md)