# FileUpload()

Uploads file to a directory on the server.

it return the [status of the upload operation](../../guides/Various/file-upload-result.md) as a struct after the file upload.

```
FileUpload( destination=string, fileField=string, accept=string, nameConflict=string, strict=boolean, allowedExtensions=any, blockedExtensions=any, mode=string, attributes=string, acl=object );
```

**Returns:** struct

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| destination | string | Yes | Absolute pathname of directory or file on web server. |  |
| fileField | string | No | Name of form field used to select the file. |  |
| accept | string | No | Limits the MIME types to accept. Comma-delimited list. For example, to permit JPG and Microsoft Word file uploads: accept = "image/jpg, application/msword" The browser uses file extension to determine file type. *Alias: mimeType* |  |
| nameConflict | string | No | Action to take if filename is the same as that of a file in the directory. - skip - error - overwrite - makeunique - forceunique *Alias: onConflict* |  |
| strict | boolean | No | true (default), only mimetypes are supported in the accept attribute. if set to false, it supports file extension/mimetypes in the accept attribute |  |
| allowedExtensions | any | No | String list or string array of allowed extensions. |  |
| blockedExtensions | any | No | String list or string array of not allowed extensions. |  |
| mode | string | No | Applies only to Solaris and HP-UX. Permissions. Octal values of UNIX chmod command. Assigned to owner, group, and other, respectively. |  |
| attributes | string | No | One attribute (Windows) or a comma-delimited list of attributes (other platforms) to set on the file. If omitted, the file's attributes are maintained. |  |
| acl | object | No | only used for S3 Resources |  |

# Examples

```cfml
<form name="myUpload" method="post" enctype="multipart/form-data">
    <input type="file" name="fileData">
    <input type="submit" name="submit">
</form>
<cfscript>
    if (structKeyExists(form, "fileData") and len(form.fileData) ){
        uploadfile = fileupload(getTempDirectory(),"form.fileData"," ","makeunique");
        writeDump(uploadfile);
    }
</cfscript>
```




## Related System Properties / Environment Variables

- [LUCEE_FILEUPLOAD_ALLOW_MIMETYPE_DETECTION](../environment-variables-system-properties.md#lucee_fileupload_allow_mimetype_detection) - Boolean value that enables using Tika to detect the mime type for unknown file uploads
  ***Type:** boolean, **Default:** true, **Introduced:** 7.0.0.312*
- [LUCEE_UPLOAD_BLOCKLIST](../environment-variables-system-properties.md#lucee_upload_blocklist) - Default block list for the tag cffile action=`upload`. A comma-separated list of extensions that are allowed when uploading files via forms
  ***Type:** string*



# Categories

[File handling](../../categories/files.md)

# See Also

[File Upload Operation Result](../../guides/Various/file-upload-result.md), [FileUploadAll()](fileuploadall.md), [<cffile>](../tags/file.md), [<cffileupload>](../tags/fileupload.md)