# FileReadLine()

Reads the current line from an open file (see [FileOpen()](fileopen.md)) and moves the current line pointer of the file to the next line.

```
FileReadLine( file=any );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| file | any | Yes | The file object *Alias: source, filepath, fileObj* |  |

# Examples

```cfml
// Example reads lines of file one at a time into an array
filePath = "/path/to/file.txt"
openFile = fileopen( filePath, "read" );
lines = [];

// IMPORTANT: must close file, use try/catch/finally to do so
try {
    while( !fileIsEoF( openFile ) ) {
        arrayAppend( lines, fileReadLine( openFile ) );
    }
} catch( any e ) {
    rethrow;
} finally {
    fileClose( openFile );
}
```







# Categories

[File handling](../../categories/files.md)

# See Also

[FileOpen()](fileopen.md)