# FileRead()

Reads an on-disk or in-memory text file or a file object created with the FileOpen function.

```
FileRead( file=any, charsetOrBufferSize=any );
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| file | any | Yes | file path or object |  |
| charsetOrBufferSize | any | No | the charset used or the size of the buffer. |  |

# Examples

```cfml
    fileRead("/path/to/file.ext");
```




## Related System Properties / Environment Variables

- [LUCEE_RESOURCE_CHARSET](../environment-variables-system-properties.md#lucee_resource_charset) - Default character set for reading from/writing to various resources (files)
  ***Type:** string, **Default:** system charset*



# Categories

[File handling](../../categories/files.md)