# FileOpen()

Opens an file to read, write, or append.

```
FileOpen( file=string, mode=string, charset=string, seekable=boolean );
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| file | string | Yes | a file path *Alias: path, filepath, source* |  |
| mode | string | No | Action to perform on the file, including the following: - read - readBinary - write - append If you do not specify the mode, Lucee opens the file in read mode. | read |
| charset | string | No | The character set of the file. |  |
| seekable | boolean | No | can be used for function fileseek |  |

# Examples

```cfml
myFile = fileOpen("filepath/filename.ext");
writeDump(myfile);
```

```cfml
// how to access the underlying resource provider info
f = "ram://demo.txt";
fileWrite(f, "demo");
dump(f.getResource().getResourceProvider().getScheme()); // ram ( i.e. the resource provider type)
```







# Categories

[File handling](../../categories/files.md)

# See Also

[FileReadLine()](filereadline.md)