# FileIsEOF()

Determines whether Lucee has reached the end of the file while reading it.

```
FileIsEOF( file=any );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| file | any | Yes | The file object. *Alias: source, filePath* |  |

# Examples

```cfml
filePath = "/path/to/file.txt"
openFile = fileopen(filePath, "read");
lines = [];
// IMPORTANT: must close file, use try/catch/finally to do so
try {
	// fileIsEOF(openFile) == false until we've read in the last line.
	while( !fileIsEoF(openFile) ) {
		arrayAppend(lines, fileReadLine( openFile ));
	}
} catch(any e) {
	rethrow;
} finally {
	fileClose(openFile);
}
```







# Categories

[File handling](../../categories/files.md)