# FileInfo()

Returns basic information about a file, including a hash `checksum` which is expensive (slower) to calculate. 

[GetFileInfo()](getfileinfo.md) returns further additional information about a file resource, but without the checksum.

**Introduced:** 5.0.0.0

```
FileInfo( file=string );
```

**Returns:** struct

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| file | string | Yes | file path *Alias: resource* |  |

# Examples

```cfml
file= getTempFile(getTempDirectory(),"demo");
dump(fileInfo(file));
```







# Categories

[File handling](../../categories/files.md)

# See Also

[DirectoryInfo()](directoryinfo.md), [GetFileInfo()](getfileinfo.md)