# FileGetMimeType()

Returns the mimetype of the given file

Using the [Apache Tika](https://tika.apache.org/) Library

```
FileGetMimeType( file=any, strict=boolean );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| file | any | Yes | file path or object *Alias: FilePath, source, path, FileObject* |  |
| strict | boolean | No | if set to true, Lucee checks the header of the file, when set to false, Lucee only checks the extension. *Alias: checkHeader, checkNotExtension* | true |

# Usage Notes

Since Lucee 6, this function now throws an exception when an empty or missing file is passed in

# Examples

```cfml
file = filegetmimetype(filepath/filename.ext);
writeDump(file);
```







# Categories

[File handling](../../categories/files.md)