# ExpandPath()

Creates an absolute, platform-appropriate path that is equivalent to the value of relative_path, appended to the base path.

This function (despite its name) can accept an absoluteor relative path in the relative_path attribute

```
ExpandPath( relative_path=string );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| relative_path | string | Yes | Relative or absolute directory reference or filename, within the current directory, (.\\ and ..\\) to convert to an absolute path. Can include forward or backward slashes. *Alias: relativePath, path* |  |

# Usage Notes

if the path doesn't exist under mappings, it will sometimes resolve to the root filesystem on Linux

# Examples

*There are currently no examples for this function.*




## Related System Properties / Environment Variables

- [LUCEE_MAPPING_FIRST](../environment-variables-system-properties.md#lucee_mapping_first) - Let's say you have the following code: `<cfinclude template="/foo/bar/index.cfm">` And you have the following mappings defined: `/foo/bar` and `/foo`. Then Lucee will look for `/index.cfm` in `/foo/bar` and for `/bar/index.cfm` in `/foo` and invoke the first `index.cfm` it finds, which could be in both mappings. If this setting is set to `true`, Lucee will only check `/foo/bar` for `index.cfm`
  ***Type:** boolean, **Default:** true*



# Categories

[File handling](../../categories/files.md)

# See Also

[Directory Placeholders](../../recipes/directory-placeholders.md), [ContractPath()](contractpath.md), [GetCurrentTemplatePath()](getcurrenttemplatepath.md), [Component Mappings](../../recipes/component-mappings.md), [Define a mapping](../../recipes/mappings-how-to-define-a-reg-mapping.md)