# ESAPIEncode()

Encodes the given string for safe output to stop Cross Site Scripting attacks.

**Status:** deprecated

**Requires Extension:** [ESAPI extension](https://download.lucee.org/#37C61C0A-5D7E-4256-8572639BE0CF5838)

```
ESAPIEncode( encodeFor=string, string=string, canonicalize=boolean, dialect=string );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| encodeFor | string | Yes | encode for what, valid values are: - css: for output inside Cascading Style Sheets (CSS) - dn: for output in LDAP Distinguished Names - html: for output inside HTML - html_attr: for output inside HTML Attributes - javascript: for output inside JavaScript - ldap: for output in LDAP queries - url: for output in URL - vbscript: for output inside vbscript - xml: for output inside XML - xml_attr: for output inside XML Attributes - xpath: for output in XPath |  |
| string | string | Yes | string to encode |  |
| canonicalize | boolean | No | If set to true, canonicalization happens before encoding. If set to false, the given input string will just be encoded. The default value for canonicalize is false. When this parameter is not specified, canonicalization will not happen. By default, when canonicalization is performed, both mixed and multiple encodings will be allowed. To use any other combinations you should canonicalize using canonicalize method and then do encoding. | false |
| dialect | string | No | Only used when "encodeFor" is set to "sql". This defines the SQL dialect used. Possible values are: * db2 * mysql_ansi * mysql * oracle |  |

# Examples

```cfml
	enc=ESAPIEncode("html","<table>");//html
	writeDump(enc);
	enc=ESAPIEncode('url','https://download.lucee.org/?type=releases');//URL
	writeDump(enc);
```







# Categories

[Encode/Decode](../../categories/esapi.md), [LDAP](../../categories/ldap.md), [XML](../../categories/xml.md), [HTML](../../categories/html.md), [JavaScript](../../categories/javascript.md)

# See Also

[EncodeForCSS()](encodeforcss.md), [EncodeForHTML()](encodeforhtml.md), [ESAPIDecode()](esapidecode.md), [HTMLCodeFormat()](htmlcodeformat.md), [HTMLEditFormat()](htmleditformat.md)