# ESAPIDecode()

Decodes a string that has been encoded with ESAPIEncode.

**Requires Extension:** [ESAPI extension](https://download.lucee.org/#37C61C0A-5D7E-4256-8572639BE0CF5838)

```
ESAPIDecode( decodeFrom=string, string=string );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| decodeFrom | string | Yes | given value is encoded as: - url: also decodes html-encoded content in Lucee 4 - html (not in Lucee 4) |  |
| string | string | Yes | string to decode |  |

# Examples

```cfml
	enc=ESAPIDecode("html","&lt;table&gt;");//html
	writeDump(enc);//<table>
	enc=encodeForURL('https://download.lucee.org/?type=releases');//URL
	writeDump(enc);
	dec=ESAPIdecode('url','http%3A%2F%2Fdownload.lucee.org%2F%3Ftype%3Dreleases');
	writeDump(dec);//https://download.lucee.org/?type=releases
```







# Categories

[Encode/Decode](../../categories/esapi.md)

# See Also

[ESAPIEncode()](esapiencode.md)