# EntityLoad()

Loads and returns an array of entities of the specified entityname.

EntityLoad (entityname, filtercriteria [,unique]

EntityLoad(entityname, filtercriteria, sortorder [, options])

```
EntityLoad( name=string, idOrFilter=any, uniqueOrOrder=any, options=any );
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| name | string | Yes | Name of the entity to be loaded. |  |
| idOrFilter | any | No | The primary key value of the entity that must be loaded or Key-value pair (Struct) of property names and values. If there are more than one key-value pair, then the AND operator is used.If specified, loads and returns an array of entities of the specified entity name that matches the filtercriteria. *Alias: id, filter* |  |
| uniqueOrOrder | any | No | when the second argument is an id then this argument defines the boolean "unique" otherwise it defines the order. - unique: If unique is set to true, then the entity is returned. If you are sure that only one record exists that matches this filtercriteria, then you can specify unique=true, so that a single entity is returned instead of an array. If you set unique=true and multiple records are returned, then an exception occurs. - order: String used to specify the sortorder of the entities that are returned.If specified, loads and returns an array of entities that satisfy the filtercriteria sorted as specified by the sortorder. *Alias: unique, order* |  |
| options | any | No | The following options to customize the output (only used when second argument is "id"): - ignorecase: Ignores the case of sort order when set to true. Use only if you specify the sortorder parameter. - offset: Specifies the position from which to retrieve the objects. - maxResults: Specifies the maximum number of objects to be retrieved. - cacheable: Whether the result has to be cached in the secondary cache. Default is false. - cachename: Name of the cache in secondary cache. - timeout: Specifies the timeout value (in seconds) for the query. |  |

# Examples

```cfml
 entityload("sample_entityname");
```







# Categories

[Cache](../../categories/cache.md), [ORM](../../categories/orm.md)