# EncryptBinary()

Encrypts binary data using a specific algorithm and encoding method.

```
EncryptBinary( bytes=any, key=string, algorithm=string, IVorSalt=any, iterations=number, precise=boolean );
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| bytes | any | Yes | Binary data to encrypt. |  |
| key | string | Yes | Key or seed used to encrypt the string. - For the CFMX_COMPAT algorithm, any combination of any number of characters; used as a seed used to generate a 32-bit encryption key. - For all other algorithms, a key in the format used by the algorithm. For these algorithms, use the GenerateSecretKey function to generate the key. |  |
| algorithm | string | No | The algorithm to use to decrypt the string. Must be the same as the algorithm used to encrypt the string. - CFMX_COMPAT(default): the CFML specific algorithm. This algorithm is the least secure option - AES: the Advanced Encryption Standard specified by the National Institute of Standards and Technology (NIST) FIPS-197 - BLOWFISH: the Blowfish algorithm defined by Bruce Schneier - DES: the Data Encryption Standard algorithm defined by NIST FIPS-46-3 - DESEDE: the "Triple DES" algorithm defined by NIST FIPS-46-3 You may also specify other algorithm names as well as the feedback mode and padding scheme where applicable (in the format algorithm/mode/padding) as documented in the Java Cryptography Architecture (JCA) Reference Guide. | cfmx_compat |
| IVorSalt | any | No | Initialization Vector for algorithms with Feedback Mode that is not ECB, or Salt for Password Based Encryption algorithms |  |
| iterations | number | No | number of Iterations for Password Based Encryption algorithms (ignored for all other algorithms). NIST recommends a minimum value of 1000. |  |
| precise | boolean | No | if set to true the input must follow the rule for that encoding a 100%, the decryptor will not try to interpret inputs that are not a 100% correct. This should be used to avoid false positives. | true |

# Examples

```cfml
	// binary data
	data = toBinary("abcd");

	// generate the key
	key = generateSecretKey("AES");

	// encrypt string
	binaryValue = encryptBinary(data, key);
	writeDump(binaryValue);
```







# Categories

[Binary data](../../categories/binary.md), [Cryptography](../../categories/crypto.md)

# See Also

[DecryptBinary()](decryptbinary.md)