# Encrypt()

Encrypts a string. Uses a symmetric key-based algorithm, in which the same key is used to encrypt and decrypt a string.

The security of the encrypted string depends on maintaining the secrecy of the key. Uses an XOR-based algorithm that uses a pseudo-random 32-bit key, based on a seed passed by the user as a function parameter.

```
Encrypt( string=string, key=string, algorithm=string, encoding=string, IVorSalt=any, iterations=number, precise=boolean );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| string | string | Yes | String to encrypt. |  |
| key | string | Yes | Key or seed used to encrypt the string. - For the CFMX_COMPAT algorithm, any combination of any number of characters; used as a seed used to generate a 32-bit encryption key. - For all other algorithms, a key in the format used by the algorithm. For these algorithms, use the [GenerateSecretKey()](generatesecretkey.md) function to generate the key. |  |
| algorithm | string | No | The algorithm to use to decrypt the string. Must be the same as the algorithm used to encrypt the string. - CFMX_COMPAT(default): the CFML specific algorithm. This algorithm is the least secure option - AES: the Advanced Encryption Standard specified by the National Institute of Standards and Technology (NIST) FIPS-197 - BLOWFISH: the Blowfish algorithm defined by Bruce Schneier - DES: the Data Encryption Standard algorithm defined by NIST FIPS-46-3 - DESEDE: the "Triple DES" algorithm defined by NIST FIPS-46-3 You may also specify other algorithm names as well as the feedback mode and padding scheme where applicable (in the format algorithm/mode/padding) as documented in the Java Cryptography Architecture (JCA) Reference Guide. | cfmx_compat |
| encoding | string | No | The binary encoding used to represent the data as a string. Must be the same as the algorithm used to encrypt the string. - Base64: the Base64 algorithm, as specified by IETF RFC 2045. - Hex: the characters A-F and 0-9 represent the hexadecimal byte values. - UU(default): the UNIX standard UUEncode algorithm . | uu |
| IVorSalt | any | No | Initialization Vector for algorithms with Feedback Mode that is not ECB, or Salt for Password Based Encryption algorithms |  |
| iterations | number | No | number of Iterations for Password Based Encryption algorithms (ignored for all other algorithms). NIST recommends a minimum value of 1000. |  |
| precise | boolean | No | if set to true the input must follow the rule for that encoding a 100%, the decryptor will not try to interpret inputs that are not a 100% correct. This should be used to avoid false positives. | true |

# Usage Notes

The new `precise` argument can be set to false for backwards compatibility [LDEV-4101](https://luceeserver.atlassian.net/browse/LDEV-4101)

# Examples

```cfml
key=generateSecretKey("AES");
testEncrypt = encrypt("safeourtree",key,"AES","base64");
writeDump(testEncrypt);
```

### Simple Example(6.2.2.58-SNAPSHOT)

```cfml
// Supported from Lucee 6.2.2.58-SNAPSHOT
encryptData = encrypt("lucee","abc","AES","Hex",3);
writeDump(encryptData);
```




## Related System Properties / Environment Variables

- [LUCEE_ENCRYPTION_ALGORITHM](../environment-variables-system-properties.md#lucee_encryption_algorithm) - Default encryption algorithm used when none is specified. The default `cfmx_compat` is not cryptographically secure - strongly recommended to use `AES` instead. Valid values: `CFMX_COMPAT`, `AES`, `BLOWFISH`, `DES`
  ***Type:** string, **Default:** cfmx_compat*



# Categories

[Cryptography](../../categories/crypto.md)

# See Also

[Encryption/Decryption with RSA public and private keys](../../recipes/encryption_decryption.md), [Decrypt()](decrypt.md), [GenerateRSAkeys()](generatersakeys.md), [GenerateSecretKey()](generatesecretkey.md), [string.encrypt()](../objects/string/encrypt.md)