# EncodeForXPath()

Encodes the given string for safe use in an XPath Query.

**Requires Extension:** [ESAPI extension](https://download.lucee.org/#37C61C0A-5D7E-4256-8572639BE0CF5838)

```
EncodeForXPath( string=string, canonicalize=boolean );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| string | string | Yes | string to encode |  |
| canonicalize | boolean | No | If set to true, canonicalization happens before encoding. If set to false, the given input string will just be encoded. The default value for canonicalize is false. When this parameter is not specified, canonicalization will not happen. By default, when canonicalization is performed, both mixed and multiple encodings will be allowed. To use any other combinations you should canonicalize using canonicalize method and then do encoding. | false |

# Examples

```cfml
  enc = EncodeForXPath( "<cfscript>", true );
  writeDump( enc );
```







# Categories

[Encode/Decode](../../categories/esapi.md), [XML](../../categories/xml.md)

# See Also

[XmlFormat()](xmlformat.md), [string.encodeForXPath()](../objects/string/encodeforxpath.md)