# EncodeForURL()

Encodes the given string for safe output in an URL.

**Requires Extension:** [ESAPI extension](https://download.lucee.org/#37C61C0A-5D7E-4256-8572639BE0CF5838)

```
EncodeForURL( string=string, canonicalize=boolean );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| string | string | Yes | string to encode |  |
| canonicalize | boolean | No | If set to true, canonicalization happens before encoding. If set to false, the given input string will just be encoded. The default value for canonicalize is false. When this parameter is not specified, canonicalization will not happen. By default, when canonicalization is performed, both mixed and multiple encodings will be allowed. To use any other combinations you should canonicalize using canonicalize method and then do encoding. | false |

# Examples

### Simple example for EncodeForURL

```cfml
<cfoutput>
	#encodeForUrl("https://docs.lucee.org/reference/functions/encodeforurl.html")#
</cfoutput>

```







# Categories

[Encode/Decode](../../categories/esapi.md)

# See Also

[string.encodeForURL()](../objects/string/encodeforurl.md)