# EncodeForSQL()

Encodes the given string for safe output in a query to reduce the risk of SQL Injection attacks.

_This method is not recommended_ -

This function is no longer suppprted by the underlying ESAPI library since 2.7.0 due to security concerns.

The use of query parameters are strongly encouraged. See [<cfqueryparam>](../tags/queryparam.md).

**Requires Extension:** [ESAPI extension](https://download.lucee.org/#37C61C0A-5D7E-4256-8572639BE0CF5838)

```
EncodeForSQL( string=string, dialect=string, canonicalize=boolean );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| string | string | Yes | string to encode |  |
| dialect | string | Yes | SQL dialect used to encode, possible values are: * db2 * mysql_ansi * mysql * oracle |  |
| canonicalize | boolean | No | If set to true, canonicalization happens before encoding. If set to false, the given input string will just be encoded. The default value for canonicalize is false. When this parameter is not specified, canonicalization will not happen. By default, when canonicalization is performed, both mixed and multiple encodings will be allowed. To use any other combinations you should canonicalize using canonicalize method and then do encoding. | false |

# Examples

```cfml
// example of an url variable:
// http://some.example.domain/dogs.cfm?name=lassie
url.name="lassie";
SQLQuery="SELECT * FROM dogs WHERE name='#url.name#';";
dump( SQLQuery );

// example of an url sql injection:
// http://some.example.domain/dogs.cfm?name='%20or%20'1'='1
url.name= "' or '1'='1";
SQLQuery="SELECT * FROM dogs WHERE name='#url.name#';";
dump( SQLQuery );

// example of preventing sql injection with encodeForSQL in MySQL:
SQLQuery="SELECT * FROM dogs WHERE name='#encodeForSQL( url.name, 'mySql' )#';";
dump( SQLQuery );
```







# Categories

[Encode/Decode](../../categories/esapi.md), [Queries](../../categories/query.md)

# See Also

[string.encodeForSQL()](../objects/string/encodeforsql.md)