# Echo()

Writes the given string to the main response buffer regardless of conditions established by the [<cfsetting>](../tags/setting.md) tag.

```
Echo( string=string );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| string | string | Yes | A string to write to the buffer. |  |

# Examples

```cfml
stru={};
stru.name="Susi";
echo(stru.name);
echo("<br>I love lucee");
```

### Nice trick with echo and cfcatch

```cfml
try {
    throw "demo echo trick";
} catch (e){
    echo(e); // outputs the error nicely using the error template
}
```







# Categories

[Debugging](../../categories/debugging.md)

# See Also

[SystemOutput()](systemoutput.md), [WriteOutput()](writeoutput.md)