# EC2describeInstances()

This function interfaces with the EC2 service to retrieve detailed information about specified EC2 instances.

It supports custom filtering, specific instance IDs, regional targeting, and legacy mode handling.

**Requires Extension:** [EC2 Extension](https://download.lucee.org/#261114AC-7372-4CA8-BA7090895E01682D)

```
EC2describeInstances( accessKeyId=string, secretAccessKey=string, instanceIds=array, filters=struct, host=string, location=string, timeout=number );
```

**Returns:** object

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| accessKeyId | string | No | Your AWS access key ID. Used for authentication with AWS services. This key must have appropriate permissions for EC2 describe instance operations. *Alias: accessKey* |  |
| secretAccessKey | string | No | Your AWS secret access key associated with the access key ID. This key is used in conjunction with the accessKeyId for authentication. *Alias: secretkey* |  |
| instanceIds | array | No | An array of instance IDs specifying the EC2 instances to describe. If not provided, information for all instances will be returned. |  |
| filters | struct | No | A struct of filters to apply to the instance description request. Each key in the struct is a filter name, and its value is an array of filter values. |  |
| host | string | No | The endpoint or the provider to connect to. If not set, Amazon AWS is used. This can be used to specify a different AWS region or a custom EC2-compatible endpoint. *Alias: provider, server* |  |
| location | string | No | The AWS region hosting the EC2 endpoint. If not specified, the default region associated with the provided credentials is used. *Alias: region* |  |
| timeout | number | No | The timeout in milliseconds for the EC2 describe instances request. Defaults to 10000 milliseconds (10 seconds). | 10000 |

# Examples

*There are currently no examples for this function*







# Categories

[S3 ](../../categories/s3.md), [Lucee Server related Tags, Functions and Guides](../../categories/server.md)