# Each()

call the given UDF/Closure with every entry (key/value) in the given collection.

**Status:** deprecated

```
Each( collection=object, closure=function, parallel=boolean, maxThreads=number );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| collection | object | Yes | collection to take values from |  |
| closure | function | Yes | UDF/Closure that call with the entries from the collection `function (value, idx, coll){}` *Alias: function, callback, udf* |  |
| parallel | boolean | No | execute closures parallel |  |
| maxThreads | number | No | maximum number of threads executed, ignored when argument "parallel" is set to false *Alias: maxThreadCount* | 20 |

# Examples

```cfml
function squareRoot(number) {
  Dump(Sqr(number));
}

numbers = [16, 64, 400];
Each(numbers, squareRoot);

```







# Categories

[Collections](../../categories/collection.md), [Threads](../../categories/thread.md)