# Duplicate()

Returns a new duplicated version of the given object, removing all references to the old one

```
Duplicate( object=any, deepCopy=boolean );
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| object | any | Yes | Name of a variable to duplicate *Alias: variable_name, obj* |  |
| deepCopy | boolean | No | If set to true (default) the child elements are also cloned. If false, child elements retain a reference to their corresponding element in the original object. **Note:** deeply cloned elements that are not native Lucee objects (i.e. Java objects) _may_ change data type when they can be converted to a native CFML object. | true |

# Examples

```cfml
person = { first = "Babe", last = "Ruth"};
dump(person); // Babe Ruth
clone = duplicate(person);
dump(clone); // Babe Ruth
person.last = "Smith";
dump(person); // Babe Smith
dump(clone); // Babe Ruth
```







# See Also

[struct.duplicate()](../objects/struct/duplicate.md)