# Dump()

Outputs the elements, variables and values of most kinds of CFML objects. Useful for debugging. You can display the contents of simple and complex variables, objects, components, user-defined functions, and other elements.

```
Dump( var=object, expand=boolean, format=string, hide=string, keys=numeric, label=string, metainfo=boolean, output=string, show=string, showUDFs=boolean, top=numeric, abort=boolean, eval=string );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| var | object | No | Variable to display. |  |
| expand | boolean | No | expands views |  |
| format | string | No | specify the output format of the dump, the following formats are supported: - simple: - a simple HTML output (no JavaScript or CSS) - text (default output="console"): plain text output (no HTML) - html (default output="browser"): regular output with HTML/CSS/JavaScript - classic: classic view with HTML/CSS/JavaScript |  |
| hide | string | No | hide column or keys. |  |
| keys | numeric | No | For a structure, number of keys to display. |  |
| label | string | No | header for the dump output. |  |
| metainfo | boolean | No | Includes information about the query in the cfdump results. |  |
| output | string | No | Where to send the results: - console: the result is written to the console (System.out). - browser (default): the result is written to the browser response stream. |  |
| show | string | No | show column or keys. |  |
| showUDFs | boolean | No | show UDFs in cfdump output. |  |
| top | numeric | No | The number of rows to display. |  |
| abort | boolean | No | stops further processing of the request. |  |
| eval | string | No | name of the variable to display, also used as label, when no label defined. |  |

# Examples

```cfml
dump(getTimeZoneInfo());
```







# Categories

[Debugging](../../categories/debugging.md)

# See Also

[WriteDump()](writedump.md), [<cfdump>](../tags/dump.md), [Custom CFDUMP Templates](../../guides/Various/TIPS/TIPS-dump-template.md)