# DirectoryRename()

Renames given directory

```
DirectoryRename( oldPath=string, newPath=string, createPath=boolean );
```

**Returns:** String

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| oldPath | string | Yes | Absolute path of the directory to be renamed |  |
| newPath | string | Yes | new name for the directory |  |
| createPath | boolean | No | if set to false, expects all parent directories to exist, true (default) will generate necessary directories |  |

# Usage Notes

With Lucee 6 this function now returns the new path

# Examples

```cfml
reNamedirectory = "directoryPath";
directoryRename(reNamedirectory,"newname");
```







# Categories

[File handling](../../categories/files.md)

# See Also

[DirectoryCopy()](directorycopy.md), [DirectoryCreate()](directorycreate.md), [DirectoryDelete()](directorydelete.md), [DirectoryExists()](directoryexists.md), [DirectoryList()](directorylist.md), [<cfdirectory>](../tags/directory.md)