# DirectoryList()

Lists the directory and returns the list of files under it as array or query

```
DirectoryList( path=string, recurse=boolean, listInfo=string, filter=any, sort=string, type=string );
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| path | string | Yes | The absolute path of the directory to list the content from. This can be any type of supported [Virtual File Systems](../../recipes/virtual-file-system.md) *Alias: absolute_path, absolutePath* |  |
| recurse | boolean | No | Specifies whether to include subdirectories in the listing. If `true`, the content of all sub-directories is also included. |  |
| listInfo | string | No | Defines the return type of this function: - `name`: returns an array of names of files and directories. - `path`: returns an array of paths of files and directories. This is the default. - `query`: returns a query object. |  |
| filter | any | No | Specifies a filter to be used to filter the results: - A string that uses `*` as a wildcard, for example, `*.cfm` - UDF (User Defined Function) using the following pattern: `boolean function(String path, String type, String ext)`. The function is run for every single file; if the function returns `true`, the file is included in the list; otherwise, it is omitted. `Type` is either `File` or `Directory` `Type` and `Ext` arguments were added in Lucee 6.0 |  |
| sort | string | No | Query columns by which to sort a directory listing. To use sort, "listInfo" must be set to "query"! Delimited list of columns from query output. Sorting is case sensitive. To qualify a column, use one of the following values: - `asc`: ascending (a to z) sort order. Default - `desc`: descending (z to a) sort order. |  |
| type | string | No | type of the result returned: - `file`: includes only filenames - `dir`: includes only directory names - `all`: includes both filenames and directory names |  |

# Usage Notes

The Unix `mode` column was not populated prior to Lucee 6.1

# Examples

To return an array of file paths that end with the substring `.log` from a the directory `/var/data`:

```cfml
    directoryList("/var/data", false, "path", function(path){ return arguments.path.hasSuffix(".log"); })
```







# Categories

[File handling](../../categories/files.md)

# See Also

[DirectoryCopy()](directorycopy.md), [DirectoryCreate()](directorycreate.md), [DirectoryDelete()](directorydelete.md), [DirectoryExists()](directoryexists.md), [DirectoryRename()](directoryrename.md), [GetFileInfo()](getfileinfo.md), [<cfdirectory>](../tags/directory.md)