# DirectoryExists()

Determines whether a directory exists.

```
DirectoryExists( path=string, allowRealPath=object );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| path | string | Yes | An absolute path. Alternatively, you can specify IP address as in the following example: DirectoryExists(\"//12.3.123.123/c_drive/test\"); *Alias: absolute_path, absolutePath* |  |
| allowRealPath | object | No | boolean that defines if relative paths are interpreted or not |  |

# Examples

```cfml
directoryExists("directoryPath");
```







# Categories

[Decision logic](../../categories/decision.md), [File handling](../../categories/files.md)

# See Also

[DirectoryCopy()](directorycopy.md), [DirectoryCreate()](directorycreate.md), [DirectoryDelete()](directorydelete.md), [DirectoryList()](directorylist.md), [DirectoryRename()](directoryrename.md), [<cfdirectory>](../tags/directory.md)