# DirectoryCreate()

Creates new directory for specified path

```
DirectoryCreate( path=string, createPath=boolean, ignoreExists=boolean, mode=string );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| path | string | Yes | Absolute path of the directory to be created |  |
| createPath | boolean | No | Create parent directory when not exist *Alias: doParent* | true |
| ignoreExists | boolean | No | Pass false (default) to throw an error if the directory already exists, or true to skip the create operation without an error | false |
| mode | string | No | Mode to for the new directory, pass -1 to inherit | 777 |

# Examples

```cfml
  // This will create parent directory when not exist
  directoryCreate( expandPath('images/uploads'), true, true);
```







# Categories

[File handling](../../categories/files.md)

# See Also

[DirectoryCopy()](directorycopy.md), [DirectoryDelete()](directorydelete.md), [DirectoryExists()](directoryexists.md), [DirectoryList()](directorylist.md), [DirectoryRename()](directoryrename.md), [<cfdirectory>](../tags/directory.md)