# DirectoryCopy()

Copies the contents of a directory to a destination directory.

```
DirectoryCopy( source=string, destination=string, recurse=boolean, filter=any, createPath=boolean );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| source | string | Yes | Pathname of directory from which you copy content. *Alias: directory* |  |
| destination | string | Yes | Path of the destination directory. If not an absolute path, it is relative to the source directory. *Alias: newDirectory* |  |
| recurse | boolean | No | If true, copies the subdirectories, otherwise only the files in the source directory. *Alias: recursive* | false |
| filter | any | No | Filter to be used to filter the data copied: - A string that uses "*" as a wildcard, for example, "*.cfm" - An UDF (User defined Function) using the following pattern "functioname(String path):boolean", the function is run for every single file, if the function returns true, then the file is will be added to the list otherwise it will be omitted |  |
| createPath | boolean | No | if set to false, expects all parent directories to exist, true (default) will generate necessary directories |  |

# Examples

```cfml
directorycopy("directorypath","directorypath")
//one directorypath to another directory path...
```







# Categories

[File handling](../../categories/files.md)

# See Also

[DirectoryCreate()](directorycreate.md), [DirectoryDelete()](directorydelete.md), [DirectoryExists()](directoryexists.md), [DirectoryList()](directorylist.md), [DirectoryRename()](directoryrename.md), [<cfdirectory>](../tags/directory.md)