# DeserializeJSON()

Converts a JSON (JavaScript Object Notation) string data representation into CFML data, such as a struct or array.

```
DeserializeJSON( JSONVar=string, strictMapping=boolean, format=string );
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| JSONVar | string | Yes | A string that contains a valid JSON construct, or variable that represents one. *Alias: json, data* |  |
| strictMapping | boolean | No | A Boolean value that specifies how to convert the JSON - TRUE Converts JSON structure strictly to CFML, using only JSON Datatypes - FALSE Query formats (like [SerializeJSON()](serializejson.md) outputs) are converted back to CFML Queries | true |
| format | string | No | The format of the input string. Possible values are: - **json**: Standard JSON format - **json5**: JSON5 format which allows additional features such as comments and unquoted keys | json5 |

# Usage Notes

Prior to Lucee 6, attempting to deserialize an empty string wouldn't throw an exception.

This was changed to be compatible with ACF.

# Examples

```cfml
json = '{
	"stringValue":"a string",
	"arrayValue": ["a","b","c"],
	"booleanValue":true,
	"numericValue": 42
}';
myStruct = deserializeJson(json);

writeDump(myStruct);
```

*Credit to Adam Cameron for [suggesting the example](http://blog.adamcameron.me/2016/01/coldfusion-how-not-to-document-function.html)*

### Strict Mapping with Queries

```cfml
    q = queryNew(
        "id,name",
        "numeric,varchar",
        {
            id: [1,2,3],
            name: ['Neo','Trinity','Morpheus']
        }
    );
    dump(q);
    dump( var=deserializeJSON( serializeJSON(q, 'column'),true ),
        label="'strictMapping TRUE'" );
    dump( var=deserializeJSON( serializeJSON(q, 'column'),false ),
        label="'strictMapping FALSE'" );

    q= { nested1: q, nested2: {q3: q} };
    dump( var=deserializeJSON( serializeJSON(q),false ),
        label="'strictMapping FALSE *nested queries*'" );
```




## Related System Properties / Environment Variables

- [LUCEE_DESERIALIZEJSON_ALLOWEMPTY](../environment-variables-system-properties.md#lucee_deserializejson_allowempty) - In Lucee 5, an empty string passed into the function deserializeJson will return an empty string back. In Lucee 6, this is no longer accepted and throws an exception. You can simulate the old behavior by setting this environment variable or SysProp to `true`. By setting the log level of the application log to `warn`, you will receive information in the log when the old behavior is used. This allows you to modify your code for the new behavior without encountering runtime issues with the existing code
  ***Type:** boolean, **Default:** false*



# Categories

[JavaScript](../../categories/javascript.md), [JSON](../../categories/json.md), [Parsing](../../categories/parsing.md), [Strings](../../categories/string.md)

# See Also

[Ajax features](../../categories/ajax.md), [Serialize()](serialize.md), [SerializeJSON()](serializejson.md), [string.deserializeJSON()](../objects/string/deserializejson.md), [<cfwddx>](../tags/wddx.md)