# DecryptBinary()

Decrypts the given binary with the optional parameters

```
DecryptBinary( binaryData=any, key=string, algorithm=string, IVorSalt=any, iterations=number, precise=boolean );
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| binaryData | any | Yes | Binary data to decrypt. *Alias: input* |  |
| key | string | Yes | Key or seed used to encrypt the string. - For the CFMX_COMPAT algorithm, any combination of any number of characters; used as a seed used to generate a 32-bit encryption key. - For all other algorithms, a key in the format used by the algorithm. For these algorithms, use the GenerateSecretKey function to generate the key. |  |
| algorithm | string | No | The algorithm to use to decrypt the string. Must be the same as the algorithm used to encrypt the string. - CFMX_COMPAT(default): the CFML specific algorithm. This algorithm is the least secure option - AES: the Advanced Encryption Standard specified by the National Institute of Standards and Technology (NIST) FIPS-197 - BLOWFISH: the Blowfish algorithm defined by Bruce Schneier - DES: the Data Encryption Standard algorithm defined by NIST FIPS-46-3 - DESEDE: the "Triple DES" algorithm defined by NIST FIPS-46-3 | cfmx_compat |
| IVorSalt | any | No | Initialization Vector for algorithms with Feedback Mode that is not ECB, or Salt for Password Based Encryption algorithms *Alias: IV, Salt, prefix* |  |
| iterations | number | No | number of Iterations for Password Based Encryption algorithms (ignored for all other algorithms). NIST recommends a minimum value of 1000. |  |
| precise | boolean | No | if set to true the input must follow the rule for that encoding a 100%, the decryptor will not try to interpret inputs that are not a 100% correct. This should be used to avoid false positives. | true |

# Usage Notes

The new `precise` argument can be set to false for backwards compatibility [LDEV-4101](https://luceeserver.atlassian.net/browse/LDEV-4101)

# Examples

```cfml
	// binary data
	data = toBinary("abcd");

	// generate the key
	key = generateSecretKey("AES");

	// encrypt string
	encryptValue = encryptBinary(data, key);
	writeDump(encryptValue);

	// decrypt string
	decryptValue = decryptBinary(encryptValue, key);
	writeDump(decryptValue);

```







# Categories

[Binary data](../../categories/binary.md), [Cryptography](../../categories/crypto.md)

# See Also

[EncryptBinary()](encryptbinary.md)