# DayOfYear()

Determines the day of the year, in a date.

```
DayOfYear( date=datetime, timezone=timezone );
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| date | datetime | Yes | date object; for example, [now()](now.md) |  |
| timezone | timezone | No | A datetime object is independent of a specific timezone; it is only an offset in milliseconds from `1970-1-1 00.00:00 UTC` (Coordinated Universal Time). The timezone only comes into play when you need specific information like hours in a day, minutes in a hour or which day it is as these calculations depend on the timezone. A timezone must be specified in order to translate the date object to something else. If you do not provide the timezone in the function call, it will default to the timezone specified in the Lucee Administrator (Settings/Regional), or the timezone specified for the current request using the function [setTimezone()](settimezone.md). You can find a list of all available timezones in the Lucee administrator (Settings/Regional). Some examples of valid timezones include: - AGT (for time in Argentina) - Europe/Zurich (for time in Zurich/Switzerland) - HST (Hawaiian Standard Time in the USA) - JVM (JVM / Server Default Timezone) |  |

# Examples

```cfml
	writeOutput("The number of days of the current year is "&dayOfYear(now()));
	d1=CreateDateTime(2016, 11, 10, 6, 10, 1);//user defined date with member function
	writeOutput("<br>The number of days of the year is "&d1.dayOfYear());
```







# Categories

[Date and time](../../categories/datetime.md)

# See Also

[datetime.dayOfYear()](../objects/datetime/dayofyear.md)