# DayOfWeek()

Returns the integer index of the day of the week for the given date. The index starts at 1 for _sunday_ and continues up to 7 for _saturday_. i.e.

* 1 = Sunday
* 2 = Monday
* 3 = Tuesday
* 4 = Wednesday
* 5 = Thursday
* 6 = Friday
* 7 = Saturday

```
DayOfWeek( date=datetime, timezone=timezone );
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| date | datetime | Yes | date object; for example, [now()](now.md) |  |
| timezone | timezone | No | A datetime object is independent of a specific timezone; it is only an offset in milliseconds from `1970-1-1 00.00:00 UTC` (Coordinated Universal Time). The timezone only comes into play when you need specific information like hours in a day, minutes in a hour or which day it is as these calculations depend on the timezone. A timezone must be specified in order to translate the date object to something else. If you do not provide the timezone in the function call, it will default to the timezone specified in the Lucee Administrator (Settings/Regional), or the timezone specified for the current request using the function [setTimezone()](settimezone.md). You can find a list of all available timezones in the Lucee administrator (Settings/Regional). Some examples of valid timezones include: - AGT (for time in Argentina) - Europe/Zurich (for time in Zurich/Switzerland) - HST (Hawaiian Standard Time in the USA) - JVM (JVM / Server Default Timezone) |  |

# Examples

```cfml
	writeOutput(DayOfWeek(now()));
	//using member function
	d=createDate(2018,07,25);
	writeOutput("<br>"&d.dayOfWeek());
```







# Categories

[Date and time](../../categories/datetime.md)

# See Also

[LSDayOfWeek()](lsdayofweek.md), [datetime.dayOfWeek()](../objects/datetime/dayofweek.md)