# DateFormat()

Formats a date object to a given string output.

```
DateFormat( date=any, mask=string, timezone=timezone );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| date | any | Yes | date object; for example, [now()](now.md) |  |
| mask | string | No | Date formatting mask: - d: Day of the month as digits; no leading zero for single-digit days. - dd: Day of the month as digits; leading zero for single-digit days. - ddd: Day of the week as a three-letter abbreviation. - dddd: Day of the week as its full name. - m: Month as digits; no leading zero for single-digit months. - mm: Month as digits; leading zero for single-digit months. - mmm: Month as a three-letter abbreviation. - mmmm: Month as its full name. - yy: Year as last two digits; leading zero for years less than 10. - yyyy: Year represented by four digits. - gg: Period/era string. Ignored. Reserved. The following masks are options to format the full date and cannot be combined with other masks: - short: equivalent to m/d/y - medium: equivalent to mmm d, yyyy - long: equivalent to mmmm d, yyyy - full: equivalent to dddd, mmmm d, yyyy | dd-mmm-yy |
| timezone | timezone | No | A datetime object is independent of a specific timezone; it is only an offset in milliseconds from `1970-1-1 00.00:00 UTC` (Coordinated Universal Time). The timezone only comes into play when you need specific information like hours in a day, minutes in a hour or which day it is as these calculations depend on the timezone. A timezone must be specified in order to translate the date object to something else. If you do not provide the timezone in the function call, it will default to the timezone specified in the Lucee Administrator (Settings/Regional), or the timezone specified for the current request using the function [setTimezone()](settimezone.md). You can find a list of all available timezones in the Lucee administrator (Settings/Regional). Some examples of valid timezones include: - AGT (for time in Argentina) - Europe/Zurich (for time in Zurich/Switzerland) - HST (Hawaiian Standard Time in the USA) - JVM (JVM / Server Default Timezone) |  |

# Examples

```cfml
	// the below code formats the date & show all the parts as two digits
	writedump(dateFormat(now(), 'yy-mm-dd'));

	//Day of the week as a three-letter abbreviation.
	writedump(dateFormat(now(), 'ddd,dd/mm/yyyy'));

	//Day of the week as its full name.
	writedump(dateFormat(now(), 'dddd,dd/mm/yyyy'));

	// the below code formats the month as short string notation
	writedump(dateFormat(now(), 'yyyy/mmm/dd'));

	// the below code formats the date & separate date parts with dot
	writedump(dateFormat(now(), 'yyyy.mmm.dd'));

	// the below code formats the date & show the full month in string
	writedump(dateFormat(now(), 'yyyy-mmmm-dd'));

	// the below code returns the date with the format of full, long, medium, short
	dt=createDate(2018);
	writedump(dateFormat(dt,"full"));
	writedump(dateFormat(dt,"long"));
	writedump(dateFormat(dt,"medium"));
	writedump(dateFormat(dt,"short"));

	//Member function, able to format the date as normal function with all possibilities
	d1=createDate(2018,07,25)
	writeDump(d1.dateFormat("MM/DD/YYYY"));
	writeDump(d1.dateFormat("dddd,MM/DD/YYYY"));
```







# Categories

[Date and time](../../categories/datetime.md), [Strings](../../categories/string.md), [Formatting](../../categories/formatting.md)

# See Also

[Date and Time Formatting in Lucee](../../recipes/date-time-formatting.md), [LSDateFormat()](lsdateformat.md), [datetime.dateFormat()](../objects/datetime/dateformat.md)