# DateDiff()

Determines the integer number of units by which date1 is less than date2.

With Lucee 6, the order of the arguments for this `.diff()` member function was changed to match ACF

[LDEV-2044](https://luceeserver.atlassian.net/browse/LDEV-2044)

```
DateDiff( datePart=string, date1=datetime, date2=datetime );
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| datePart | string | Yes | The specific units in which to count: - yyyy: Years - q: Quarters - m: Months - y: Day of Year (same as d) - d: Days (same as y) - w: Weeks (same as ww) - ww: Weeks (same as w) - wd: Weekdays - h: Hours - n: Minutes - s: Seconds - l: MilliSeconds |  |
| date1 | datetime | Yes | date object; for example, [now()](now.md) |  |
| date2 | datetime | Yes | date object; for example, [now()](now.md) |  |

# Examples

```cfml
echo( DateDiff( "d", "2016-06-27", "2016-06-28" ) & "<br>" ); // 1
echo( DateDiff( "d", "2016-06-27", "2016-06-27" ) & "<br>" ); // 0
echo( DateDiff( "d", "2016-06-27", "2016-06-26" ) & "<br>" ); // -1

echo( DateDiff( "h", "2016-06-27 00:00:00", "2016-06-27 01:00:00" ) & "<br>" ); // 1
echo( DateDiff( "h", "2016-06-27 00:00:00", "2016-06-27 00:00:00" ) & "<br>" ); // 0
echo( DateDiff( "h", "2016-06-27 01:00:00", "2016-06-27 00:00:00" ) & "<br>" ); // -1
echo( DateDiff( "wd", "2016-06-27 00:00:00", "2016-07-27 01:00:00" ) & "<br>" ); // 22
```







# Categories

[Date and time](../../categories/datetime.md)

# See Also

[datetime.diff()](../objects/datetime/diff.md)