# DateCompare()

Compares two dates to a given optional resolution.

Returns -1 if date1 is before date2.

Returns 1 if date1 is after date2.

Returns 0 if date1 and date2 are equal.

```
DateCompare( date1=datetime, date2=datetime, datePart=string );
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| date1 | datetime | Yes | date object; for example, [now()](now.md) |  |
| date2 | datetime | Yes | date object; for example, [now()](now.md) |  |
| datePart | string | No | Precision of the comparison: - s (default): Precise to the second - n: Precise to the minute - h: Precise to the hour - d: Precise to the day - m: Precise to the month - yyyy: Precise to the year | s |

# Examples

```cfml
	writeOutput(dateCompare(now(), '11/10/1992')&" (Date1 is later than date2)<br>");
	writeOutput(dateCompare('11/10/1992', '11/10/1992')&" (Date1 is equal to date2)<br>");
	writeOutput(dateCompare('11/10/1992', now())&" Date1 is earlier than date2");
```

### Member function

```cfml
	d=createDate(year(now()),month(now()),day(now()));
	d1='11/10/1992';
	writeOutput(d.Compare('11/10/1992')&" Date1 is later than date2<br>");0
	writeOutput(d.Compare(d)&" (Date1 is equal to date2)<br>");
	writeOutput(d1.Compare(d)&" Date1 is earlier than date2");
```







# Categories

[Date and time](../../categories/datetime.md)

# See Also

[datetime.compare()](../objects/datetime/compare.md)