# DateAdd()

Adds units of time to a date object.

```
DateAdd( datePart=string, number=number, date=datetime );
```

**Returns:** datetime

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| datePart | string | Yes | One of the following units: - yyyy: Year - q: Quarter - m: Month - y: Day of year - d: Day - w: Weekday - ww: Week - h: Hour - n: Minute - s: Second - l: Millisecond |  |
| number | number | Yes | Number of units of datepart to add to date (positive, to get dates in the future; negative, to get dates in the past). Number must be an integer. |  |
| date | datetime | Yes | date object; for example, [now()](now.md) |  |

# Examples

```cfml
  // the below code increments 10 milliseconds in actual date
  dump(dateAdd("l", 10, now()));

  // the below code increments 60 seconds in actual date
  dump(dateAdd("s", 60, now()));

  // the below code increments 60 minutes in actual date
  dump(dateAdd("n", 60, now()));

  // the below code increments 2 hours in actual date
  dump(dateAdd("h", 2, now()));

  // the below code increments 1 day in actual date
  dump(dateAdd("d", 1, now()));

  // the below code increments 1 month in actual date
  dump(dateAdd("m", 1, now()));

  // the below code increments 1 year in actual date
  dump(dateAdd("yyyy", 1, now()));
```







# Categories

[Date and time](../../categories/datetime.md)

# See Also

[datetime.add()](../objects/datetime/add.md)