# CSRFVerifyToken()

Validates the given token against the same stored in the session for a specific key.

```
CSRFVerifyToken( token=string, key=string, remove=boolean );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| token | string | Yes | Token that to be validated against the token stored in the session. |  |
| key | string | No | The key against which the token be searched. |  |
| remove | boolean | No | Also remove the token from the session if it exists. | false |

# Examples

```cfml
key = "+nn7jqV+3hYHM++RuvE47g==";
new_token = CSRFGenerateToken(key, true);
dump(CSRFVerifyToken(new_token,key)); //true
```







# Categories

[Cryptography](../../categories/crypto.md), [Session](../../categories/session.md)

# See Also

[CSRFGenerateToken()](csrfgeneratetoken.md)