# CSRFGenerateToken()

Provides a random token and stores it in the session. You can also provide a specific key to store in the session.

```
CSRFGenerateToken( key=string, forceNew=boolean );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| key | string | No | A random token is generated for the key provided. |  |
| forceNew | boolean | No | If set to true, a new token is generated every time the function is called. If false, in case a token exists for the key, the same key is returned. |  |

# Examples

```cfml
dump(CSRFGenerateToken("+nn7jqV+3hYHM++RuvE47g==", true));
```







# Categories

[Cryptography](../../categories/crypto.md), [Session](../../categories/session.md)

# See Also

[CSRFVerifyToken()](csrfverifytoken.md)