# CreateULID()

Generates a ULID (Universally Unique Lexicographically Sortable Identifier), a 128-bit identifier where the first 48 bits are a timestamp representing milliseconds since the Unix Epoch (1970-01-01), ensuring temporal ordering. 

The remaining 80 bits are populated by a secure random number generator, contributing to the identifier's uniqueness. The output is a 26-character string in its canonical representation. 

This function can operate in three modes specified by the 'type' argument:

- `empty` for standard ULID generation
- `monotonic` to ensure sequential IDs even in rapid succession
-  and `hash` to generate a ULID based on hashed input values.

ULIDs are better for insert performance, as they don't create sparse B-Tree indexes like UUIDs, saving disk space

**Introduced:** 6.0.1.65

```
CreateULID( type=string, input1=number, input2=string );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| type | string | No | Specifies the generation mode of the ULID. If not defined, a standard ULID is generated. - `monotonic` ensures ULIDs increase monotonically, suitable for ensuring order in rapid generation scenarios. - `hash` mode generates a ULID based on hashing the provided inputs, useful for creating deterministic identifiers. |  |
| input1 | number | No | Used in conjunction with the `hash` type, this numeric input contributes to the generation of a deterministic ULID by influencing its random component. only used for hash |  |
| input2 | string | No | Similar to `input1`, this string input is utilized only in the `hash` mode to further seed the ULID's random component, enabling the creation of a deterministic ULID based on the hash of the inputs. |  |

# Examples

```cfml
loop times=3 {
	dump( createULID() );
}

loop times=3 {
	dump( createUUID() );
}
```







# Categories

[Core CFML Language](../../categories/core.md)

# See Also

[CreateGUID()](createguid.md), [CreateUUID()](createuuid.md)