# CreateDateTime()

Creates a CFML date/time object from the given year, month, day, hour, minute and second.

```
CreateDateTime( year=number, month=number, day=number, hour=number, minute=number, second=number, millisecond=number, timezone=timezone );
```

**Returns:** datetime

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| year | number | Yes | Integer in the range 0-9999. Integers in the range 0-29 are converted to 2000-2029. Integers in the range 30-99 are converted to 1930-1999. You cannot specify dates before AD 100. *Alias: years* |  |
| month | number | No | Integer in the range 1-12 *Alias: months* | 1 |
| day | number | No | Integer in the range 1-31 *Alias: days* | 1 |
| hour | number | No | Integer in the range 0-23 *Alias: hours* | 0 |
| minute | number | No | Integer in the range 0-59 *Alias: minutes* | 0 |
| second | number | No | Integer in the range 0-59 *Alias: seconds* | 0 |
| millisecond | number | No | Integer in the range 0-999 *Alias: milliseconds, millis* | 0 |
| timezone | timezone | No | A datetime object is independent of a specific timezone; it is only an offset in milliseconds from `1970-1-1 00.00:00 UTC` (Coordinated Universal Time). The timezone only comes into play when you need specific information like hours in a day, minutes in a hour or which day it is as these calculations depend on the timezone. A timezone must be specified in order to translate the date object to something else. If you do not provide the timezone in the function call, it will default to the timezone specified in the Lucee Administrator (Settings/Regional), or the timezone specified for the current request using the function [setTimezone()](settimezone.md). You can find a list of all available timezones in the Lucee administrator (Settings/Regional). Some examples of valid timezones include: - AGT (for time in Argentina) - Europe/Zurich (for time in Zurich/Switzerland) - HST (Hawaiian Standard Time in the USA) - JVM (JVM / Server Default Timezone) |  |

# Examples

```cfml
    mydate = createDateTime(year(now()), month(now()), day(now()), hour(now()), minute(now()), second(now()));
    writeOutput("The time is " & timeFormat(myDate, "HH:MM:ss") & " on " & dateFormat(myDate, "dddd, d mmmm yyyy") & ".");
```







# Categories

[Date and time](../../categories/datetime.md)