# ContractPath()

Does the opposite of `expandPath`. Tries to match a given absolute path to mappings in the environment and will return a path that is contracted by the shortest matched mapping. If there are no matches, Lucee returns the absolute path it was given.

```
ContractPath( path=string, placeholder=boolean );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| path | string | Yes | An absolute path. *Alias: absolute_path, absolutePath* |  |
| placeholder | boolean | No | A boolean indicating whether Lucee placeholder names should be prefixed to the path. Default: false. |  |

# Examples

Assume the following folder structure:

```
homefolder
\___ luceecode
    \___ contractpath
    |   \___ example.cfm
    \___ otherdirectory
        \___ example.cfm
```

And assume the following mappings:

  * /contractdemo = /homefolder/luceecode/contractpath
  * /luceestuff = /homefolder/luceecode

```cfml
writeOutput( expandPath('example.cfm') );
// Outputs: /homefolder/luceecode/contractpath/example.cfm

writeOutput( contractPath( expandPath('example.cfm') ) );
// Outputs: /contractdemo/example.cfm

writeOutput( contractPath( expandPath('../otherdirectory/example.cfm') ) );
// Outputs: /luceestuff/otherdirectory/example.cfm

writeOutput( contractPath( expandPath('../../'), true ) );
// Outputs: /{home-directory}
```







# Categories

[File handling](../../categories/files.md)

# See Also

[ExpandPath()](expandpath.md)