# configTranslate()

translate an old Lucee XML configuration to the new JSON configuration

**Introduced:** 6.0.0.460

```
configTranslate( source=string, target=string, type=string, mode=string, charset=string );
```

**Returns:** struct

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| source | string | Yes | Path to the Lucee XML file (lucee-server.xml or lucee-web.xml.cfm) file or the data itself as a String. *Alias: data, input* |  |
| target | string | No | Path to the new `.CFConfig.json` file. *Alias: output* |  |
| type | string | No | Config Context to manipulate, server or web context. | server |
| mode | string | No | Only used when type is set to [server], should be the resulting json set for single or multi mode. |  |
| charset | string | No | charset to use to read the XML file, if not defined, Lucee will use the default resource charset. |  |

# Examples

```cfml

//Translate Lucee Server XML configuration to .CFConfig JSON format
configResult = configTranslate(
    source = "C:/lucee_old/tomcat/lucee-server/context/lucee-server.xml.cfm",
    target = "C:/lucee_new/tomcat/lucee-server/context/.CFConfig.json",
    type = "server",
    mode = "single"
);
writeDump(configResult);

```







# Categories

[Lucee Server related Tags, Functions and Guides](../../categories/server.md)

# See Also

[Configuration - CFConfig.json](../../recipes/configuration.md), [ConfigImport()](configimport.md)