# ConfigImport()

Imports server configuration defineď based on the [CFConfig](https://cfconfig.ortusbooks.com/the-basics/config-items) schema. 

This configuration can be provided as a path (String) to a JSON based file or as a `Struct`.

The values inside the provided configuration can use placeholders, following this pattern ${key:default}.

The function will check for the actual values for this placeholders in 3 places (in this order):

- Function arguments "params" (if provided)
- System properties
- Environment variables

[Directory Placeholders](../../recipes/directory-placeholders.md) will be passed thru and dynamically evaluated when used.

**Introduced:** 6.0.0.460

```
ConfigImport( path=any, type=string, password=string, params=struct, flushExistingData=boolean, charset=string );
```

**Returns:** struct

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| path | any | Yes | Path to the .CFConfig.json file or the data itself as a Struct. *Alias: path, data* |  |
| type | string | No | Config Context to manipulate, server or web context. | server |
| password | string | No | Password to access the configuration, depending on the value set for the attribute type. If not set Lucee will check in the following places for the password (replace {type} with the actual type chosen for the attribute type). Environment variable "LUCEE_{type}_ADMIN_PASSWORD" or system property "lucee.{type}.admin.password". |  |
| params | struct | No | placeholder parameters to use as actual data for the placeholders inside the configuration, see main description of this function for more details. |  |
| flushExistingData | boolean | No | if true that existing data get replaced with the given data, if set to false they get updated. |  |
| charset | string | No | charset to use to read the .CFConfig file, if not defined, Lucee will use the default resource charset. |  |

# Examples

```cfml

// Import Lucee Server configuration to CFConfig JSON format
data = {
    "extensions": [
        {
            "id": "EFDEB172-F52E-4D84-9CD1-A1F561B3DFC8",
            "name": "Lucene Search",
            "version": "2.4.2.4"
        }
    ]
};
writeDump(ConfigImport(data, "server", "lucee_password"));

```

```cfml

// Import Lucee Server configuration from a .CFConfig JSON file
writeDump(ConfigImport("path/to/.CFConfig.json", "server", "lucee_password"));

```







# Categories

[Lucee Server related Tags, Functions and Guides](../../categories/server.md)

# See Also

[Scheduled Tasks - efficiently updating in a single operation](../../recipes/cfschedule-bulk-update.md), [Configuration - CFConfig.json](../../recipes/configuration.md), [configTranslate()](configtranslate.md), [Startup Listeners: Server.cfc and Web.cfc](../../recipes/startup-listeners-code.md)