# Compress()

Compress given source to different formats.

```
Compress( format=string, source=string, target=string, includeBaseFolder=boolean, mode=string );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| format | string | Yes | Compression Format - bzip - bzip2 - gzip - tar - tar.bz - tbz (tar bzip) - tbz2 - tgz (tar gzip) - tar.gz - zip |  |
| source | string | Yes | source file or directory to compress **Note:** For gzip & bzip format must use the file path as the source |  |
| target | string | Yes | name of the target compressed file |  |
| includeBaseFolder | boolean | No | take the folder or only content of folder | true |
| mode | string | No | mode of the values | 777 |

# Examples

```cfml
test_file = fileOpen("test.txt", "append");
fileWriteLine(test_file, "The Lucee project is led by the Lucee Association Switzerland a non-profit swiss association. A growing project which is committed to the success of its community by delivering quality software and a nurturing and supportive environment for developers to get involved.");
fileWriteLine(test_file, "");
fileWriteLine(test_file, "The members of the Lucee Association Switzerland are responsible for steering the direction of the association. We are proud to have members from around the world that guide the association with their in-depth skills across the board. Being a member however is not an one-way street and there are many ways you can benefit from being a member.");
fileWriteLine(test_file, "");
fileClose(test_file);

// compress the original file
Compress("gzip","test.txt","compressed_test.txt");

dump(GetFileInfo("test.txt").size);
dump(GetFileInfo("compressed_test.txt").size);

// remove the files to keep clutter down
filedelete("test.txt");
filedelete("compressed_test.txt");
```







# Categories

[Zip files](../../categories/zip.md)

# See Also

[Extract()](extract.md), [<cfzip>](../tags/zip.md)