# CollectionReduce()

Iterates over every entry of the collection and calls the closure with every element.
This function will reduce the array to a single value and will return the value.

```
CollectionReduce( collection=object, closure=function, initialValue=object );
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| collection | object | Yes | collection to iterate *Alias: object* |  |
| closure | function | Yes | function/closure that implements the following constructor [function(... depending on the given collection ...):any]. *Alias: function, callback, udf* |  |
| initialValue | object | No | initial value passed as part of the first closure call *Alias: initial, initalValue* |  |

# Examples

```cfml
thresholds = [1, 3, 4, 5];

score = CollectionReduce(thresholds, function(a, b) {
  return a + b^2;
}, 0);

dump(score); // 51

score = thresholds.reduce(function(a, b) {
  return a + b^2;
}, 0);

dump(score); // 51
```







# Categories

[Collections](../../categories/collection.md)