# CollectionMap()

Calls the given closure with every element in the given collection.
the function returns an array or struct (depending on the input) that contains all values returned by the closure.

```
CollectionMap( collection=object, closure=function, parallel=boolean, maxThreads=number );
```

**Returns:** object

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| collection | object | Yes | collection to iterate *Alias: object* |  |
| closure | function | Yes | UDF/Closure that is called with every value in the collection *Alias: function, callback, udf* |  |
| parallel | boolean | No | execute closures parallel |  |
| maxThreads | number | No | maximum number of threads executed, ignored when argument "parallel" is set to false *Alias: maxThreadCount* | 20 |

# Examples

```cfml
// array
people = [ { name = "Alice", age = 32 }, { name = "Bob", age = 29 }, { name = "Eve", age = 41 }];

dump(CollectionMap(people, function(p) { return p.name; }));

// member function
dump(people.map(function(p) { return p.name; }));

// struct
person = { name = "Alice", age = 32, email = "alice@example.com" };

dump(CollectionMap(person, function(key,value) { return isnumeric(value); }));

// member function
dump(person.map(function(key,value) { return isnumeric(value); }));
```







# Categories

[Collections](../../categories/collection.md)