# CollectionFilter()

This function creates a new collection that returns all entries from an collection that match the given filter.

```
CollectionFilter( collection=object, filter=function, parallel=boolean, maxThreads=number );
```

**Returns:** object

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| collection | object | Yes | collection to filter entries from *Alias: object* |  |
| filter | function | Yes | filter can be a function/closure that implements the following constructor [function(... depending on given collection ...):boolean]. |  |
| parallel | boolean | No | execute closures parallel |  |
| maxThreads | number | No | maximum number of threads executed, ignored when argument "parallel" is set to false *Alias: maxThreadCount* | 20 |

# Examples

```cfml
people = [ { name = "Alice", age = 32 }, { name = "Bob", age = 29 }, { name = "Eve", age = 41 }];

dump(CollectionFilter(people, function(p) { return p.age > 30; }));

// member function
dump(people.filter(function(p) { return p.age > 30; }));
```







# Categories

[Collections](../../categories/collection.md)