# CollectionEvery()

This function calls a given closure/function with every element in a given collection and returns true, if all of the closure calls returns true.

```
CollectionEvery( collection=object, closure=function, parallel=boolean, maxThreads=number );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| collection | object | Yes | collection to iterate *Alias: object* |  |
| closure | function | Yes | function/closure that implements the following constructor [function(... depends on the given collection ...):boolean]. *Alias: function, callback, udf* |  |
| parallel | boolean | No | execute closures parallel |  |
| maxThreads | number | No | maximum number of threads executed, ignored when argument "parallel" is set to false *Alias: maxThreadCount* | 20 |

# Examples

```cfml
people = [ { name = "Alice", age = 32 }, { name = "Bob", age = 29 }, { name = "Eve", age = 41 }];

dump(CollectionEvery(people, function(p) { return p.age > 20; })); // true

// member function
dump(people.every(function(p) { return p.age > 30; })); // false
```







# Categories

[Collections](../../categories/collection.md)