# CollectionEach()

call the given UDF/Closure with every entry (key/value) in the given collection.

```
CollectionEach( collection=object, closure=function );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| collection | object | Yes | collection to take values from *Alias: object* |  |
| closure | function | Yes | UDF/Closure that call with the entries from struct *Alias: function, callback, udf* |  |

# Examples

```cfml
people = [ { name = "Alice", age = 32 }, { name = "Bob", age = 29 }, { name = "Eve", age = 41 }];

CollectionEach(people, function(p) { dump(p.name); });

// member function
people.each(function(p) {
  dump(p.name);
});
```







# Categories

[Collections](../../categories/collection.md)